/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.css.core.CSSCorePlugin;
import com.aptana.css.core.index.CSSIndexQueryHelper;
import com.aptana.css.core.internal.index.CSSIndexWriter;
import com.aptana.css.core.internal.index.CSSMetadataReader;
import com.aptana.css.core.internal.index.Messages;
import com.aptana.css.core.model.ElementElement;
import com.aptana.css.core.model.PropertyElement;
import com.aptana.css.core.model.PseudoClassElement;
import com.aptana.css.core.model.PseudoElementElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.MetadataLoader;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSMetadataLoader
extends MetadataLoader<CSSMetadataReader> {
    public CSSMetadataLoader() {
        super(Messages.CSSMetadataLoader_Loading_Metadata);
    }

    protected CSSMetadataReader createMetadataReader() {
        return new CSSMetadataReader();
    }

    protected Bundle getBundle() {
        return CSSCorePlugin.getDefault().getBundle();
    }

    protected double getIndexVersion() {
        return 0.13;
    }

    protected String getIndexVersionKey() {
        return "CSS_INDEX_VERSION";
    }

    protected String[] getMetadataFiles() {
        return new String[]{"/metadata/css_metadata.xml"};
    }

    protected String getPluginId() {
        return "com.aptana.css.core";
    }

    protected void writeIndex(CSSMetadataReader reader) {
        this.getIndexManager().resetIndex(URI.create("css.metadata:/css"));
        CSSIndexWriter indexer = new CSSIndexWriter();
        Index index = this.getIndex();
        for (ElementElement element : reader.getElements()) {
            indexer.writeElement(index, element);
        }
        for (PropertyElement property : reader.getProperties()) {
            indexer.writeProperty(index, property);
        }
        for (PseudoClassElement pseudoClass : reader.getPseudoClasses()) {
            indexer.writePseudoClass(index, pseudoClass);
        }
        for (PseudoElementElement pseudoElement : reader.getPseudoElements()) {
            indexer.writePseudoElement(index, pseudoElement);
        }
        try {
            index.save();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSCorePlugin.getDefault(), (Throwable)e);
        }
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    protected Index getIndex() {
        return CSSIndexQueryHelper.getIndex();
    }
}

